// globalish variables
var divID = "breatheInID";
var mystring="breathe in breathe out -";
var charColors = [
    "#595959", // b
    "#595959", // r
    "#595959", // e
    "#595959", // a
    "#595959", // t
    "#595959", // h
    "#595959", // e
    "#595959", //  
    "#595959", // i
    "#595959", // n
    "#595959", //  
    "#7F7F7F", // b
    "#7F7F7F", // r
    "gray",    // e
    "gray",    // a
    "gray",    // t
    "gray",    // h
    "#939393", // e
    "#939393", // 
    "#A6A6A6", // o
    "#A6A6A6", // u
    "#A6A6A6", // t
    "#A6A6A6", // 
    "#A6A6A6", // -
];
var offset=0.0;
var isAnimating = true;

function loadstring(s) {
    // put each character of the string s into an array
    var thearray = [];
    for (var i = 0, strLength=s.length; i < strLength; i++) {
        thearray.push(s[i]);
    }
    return thearray;
}

function regenerateThisElement(div, s) {
    // draw my string as a sin wave
    var strArray = loadstring(s);
    var max = 6;
    var frac;
    var ypos;
    div.innerHTML = "";
    for (var i = 0, strLength=strArray.length; i < strLength; i++) {
        frac = (i / (strLength-1.0)); // [0..1]
        frac = frac + offset;
        ypos = Math.floor(max * Math.sin(2*frac*2*Math.PI));
        div.innerHTML +=  '<span style="position:relative; color:' + charColors[i] + 
            '; padding:0.75pt; top: ' +  ypos.toString() +
            'px;">' + strArray[i] + '</span>';
    }
    return;
}

function setupClickToggle(div) {
    // toggle animation if you can manage to click this
    div.onclick = function () {
        alert("OK");
        isAnimating = !isAnimating;
        drawAndMaybeAnimate(div);
    }
}

function drawAndMaybeAnimate(div) {
    // draw one time
    regenerateThisElement(div, mystring);            

    // and if animating, tweak and setup to draw again
    if(!isAnimating)
        return;

    offset = offset + 0.01;
    if(offset > 1.0) {
        offset = offset - 1.0;
    }

    setTimeout(function () {
        drawAndMaybeAnimate(div);
    }, 100);
}

window.onload = function () {
    // get the ball rolling, setup click toggle and draw the element
    var div = document.getElementById(divID);
    setupClickToggle(div);
    drawAndMaybeAnimate(div);
}
