// this should be made smarter or something
window.onload = function () {

function loadstring(s) {
    var thearray = [];
    for (var i = 0, strLength=s.length; i < strLength; i++) {
        thearray.push(s[i]);
    }
    // the magic happens here. s goes into thearray. like each character or something.
    return thearray;
}

var start = Date.now();

var vis = d3.selectAll(".rp-wavy")

//TODO: why isn't phase working?
vis.each(function(d,i) {
    var wavyParams = {
        "animate": "true",
        "phase": "0",
        "amplitude": "6",
        "frequency": "1",
        "wavelength": "1"
    };
    var setAttributes = this.dataset;
    // override with any set attributes
    for (var attrname in setAttributes) { wavyParams[attrname] = setAttributes[attrname]; }
    var selectedParent = d3.select(this);
    var myArray = loadstring(selectedParent.text());
    selectedParent.text("");
    var myLength = myArray.length;
    var offset = 0;
    //console.log(wavyParams.phase);
    var waveFunction = function(d,i) {
            var denom = parseFloat(wavyParams.wavelength) * (myLength - 1.0);
            var frac = (i / denom); // [0..1]
            frac = frac + parseFloat(wavyParams.frequency) * (2*Math.PI*parseFloat(wavyParams.phase) + offset);
            var ypos = Math.floor(parseFloat(wavyParams.amplitude) * Math.sin(frac*2*Math.PI));
            return String(ypos)+"px"
        };

    selectedParent.selectAll("span")
        .data(myArray)
        .enter().append("span")
        .style("position", "relative")
        .style("margin", "0")
        .style("padding", "0.75pt")
        .style("top", waveFunction)
        .text(String);

    if(wavyParams.animate === 'true') {
        d3.timer(function() {
            var elapsed = Date.now() - start;
            offset = elapsed/1000.0;

            selectedParent.selectAll("span")
                .data(myArray)
                .style("top", waveFunction);
        });        
    }

})

var lerp = function(t, a, b) {
  return (a + t * (b - a));
}

var vfr = d3.selectAll(".rp-frame")

vfr.each(function(d,i) {
    var frameParams = {
        "animate": "true",
        "keys": "letter-spacing,color",
        "duration": "2"
    };
    var setAttributes = this.dataset;
    // override with any set attributes
    for (var attrname in setAttributes) { frameParams[attrname] = setAttributes[attrname]; }
    var keyArray = frameParams.keys.split(",");
    var keySet = _.reduce(keyArray, function(memo, str) { memo[str] = true; return memo}, {});
    var selectedParent = d3.select(this);
    var framedata = selectedParent[0][0].children;
    var framedataArray = Array.prototype.slice.call( framedata )
    var frames = framedataArray.map(function(frame) {
        var elements = frame.children;
        var elementsArray = Array.prototype.slice.call( elements )
        return elementsArray.map(function(item) {
            var sRow = d3.select(item);
            var map = {};
            if( "letter-spacing" in keySet ) {
                var spacing = sRow.style("letter-spacing")
                var spacingNum = (spacing == "normal") ? "0" : parseFloat(spacing);
                map.spacing = spacingNum;
            }
            if( "top" in keySet ) {
                var spacing = sRow.style("top")
                var spacingNum = (spacing == "auto") ? "0" : parseFloat(spacing);
                map.top = spacingNum;
                //console.log("top is " + spacing);
            }
            if( "right" in keySet ) {
                var spacing = sRow.style("right")
                var spacingNum = (spacing == "auto") ? "0" : parseFloat(spacing);
                map.right = spacingNum;
                //console.log("top is " + spacing);
            }
            if( "color" in keySet ) {
                var color_string = sRow.style("color");
                var re = /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/;
                var bits = re.exec(color_string);
                var colorArray = [0,0,0];
                if(bits) {
                    var colorArray = [parseInt(bits[1], 10), parseInt(bits[2], 10), parseInt(bits[3], 10)];
                }
                map.color = colorArray;
            }
            if( "text" in keySet ) {
                map.text = sRow.text();
            }
            return map;
        });
    });
    //console.log(frames);
    var numFrames = frames.length;
    // remove children (frames) after 0th
    var extras = framedataArray.slice(1);
    extras.forEach(function(child) {
        var sChild = d3.select(child);
        sChild.remove();
    });
    //console.log(framedataArray);

    var offset = 0;
    // we might eventually have a function here (for non-animating)

    if(frameParams.animate === 'true') {
        d3.timer(function() {
            var elapsed = Date.now() - start;
            offset = 0.5 * elapsed/1000.0;
            var curFrame = Math.floor( offset );
            var remainder = offset - curFrame;
            curFrame = curFrame % numFrames;
            var nextFrame = (curFrame + 1) % numFrames;

            var child = d3.select(selectedParent[0][0].children[0]);
            var node = child.selectAll("span");
            if( "letter-spacing" in keySet ) {
                node.style("letter-spacing", function(d,i) {
                    //console.log(i + ")how about " + remainder + "," + frames[curFrame][i].spacing + "," + frames[nextFrame][i].spacing + ",")
                    var curSpacing = lerp(remainder, frames[curFrame][i].spacing, frames[nextFrame][i].spacing);
                    return String(curSpacing)+"px";
                });
            }
            if( "top" in keySet ) {
                node.style("top", function(d,i) {
                    var curSpacing = lerp(remainder, frames[curFrame][i].top, frames[nextFrame][i].top);
                    return String(curSpacing)+"px";
                });
            }
            if( "right" in keySet ) {
                node.style("right", function(d,i) {
                    var curSpacing = lerp(remainder, frames[curFrame][i].right, frames[nextFrame][i].right);
                    return String(curSpacing)+"px";
                });
            }
            if( "color" in keySet ) {
                node.style("color", function(d,i) {
                    var r =  Math.floor(lerp(remainder, frames[curFrame][i].color[0], frames[nextFrame][i].color[0]));
                    var g =  Math.floor(lerp(remainder, frames[curFrame][i].color[1], frames[nextFrame][i].color[1]));
                    var b =  Math.floor(lerp(remainder, frames[curFrame][i].color[2], frames[nextFrame][i].color[2]));
                    var s = "rgb(" + r + "," + g + "," + b + ")";
                    //console.log("How about " + s)
                    return s;
                });
            }
            if( "text" in keySet ) {
                node.text(function(d,i) {
                    return frames[curFrame][i].text;
                });
            }
        });
    }

})

}
