window.onload = function () {
var is_chrome = ((navigator.userAgent.toLowerCase().indexOf('chrome') > -1) &&(navigator.vendor.toLowerCase().indexOf("google") > -1));
			   
if(is_chrome == true){
	var metas = document.getElementsByTagName("meta");
	for(i = 0; i < metas.length; i++){
		if(metas[i].getAttribute("name") == "viewport"){
			metas[i].setAttribute("content","width=device-width");
			break;
		}
	}

}
}


//Orientation Change
function doOnOrientationChange()
  {

var is_chrome = ((navigator.userAgent.toLowerCase().indexOf('chrome') > -1) &&(navigator.vendor.toLowerCase().indexOf("google") > -1));


    switch(window.orientation) 
    {  
      case -90:
      case 90:
        if(is_chrome != true){
	var metas = document.getElementsByTagName("meta");
	for(i = 0; i < metas.length; i++){
		if(metas[i].getAttribute("name") == "viewport"){
			metas[i].setAttribute("content","width=device-width, initial-scale=1.0");
			break;
		}
	}

}
        break; 
      default:
        if(is_chrome != true){
	var metas = document.getElementsByTagName("meta");
	for(i = 0; i < metas.length; i++){
		if(metas[i].getAttribute("name") == "viewport"){
			metas[i].setAttribute("content","width=device-width, initial-scale=0.5");
			break;
		}
	}

}
        break; 
    }
  }

window.addEventListener('orientationchange', doOnOrientationChange);



doOnOrientationChange();


//=========================

// left: 37, up: 38, right: 39, down: 40,
// spacebar: 32, pageup: 33, pagedown: 34, end: 35, home: 36
var keys = {37: 1, 38: 1, 39: 1, 40: 1};

function preventDefault(e) {
  e = e || window.event;
  if (e.preventDefault)
      e.preventDefault();
  e.returnValue = false;  
}

function preventDefaultForScrollKeys(e) {
    if (keys[e.keyCode]) {
        preventDefault(e);
        return false;
    }
}

function disableScroll() {
  if (window.addEventListener) // older FF
      window.addEventListener('DOMMouseScroll', preventDefault, false);
  window.onwheel = preventDefault; // modern standard
  window.onmousewheel = document.onmousewheel = preventDefault; // older browsers, IE
  window.ontouchmove  = preventDefault; // mobile
  document.onkeydown  = preventDefaultForScrollKeys;
}

function enableScroll() {
    if (window.removeEventListener)
        window.removeEventListener('DOMMouseScroll', preventDefault, false);
    window.onmousewheel = document.onmousewheel = null; 
    window.onwheel = null; 
    window.ontouchmove = null;  
    document.onkeydown = null;  
}












//===============================


















//===============================


document.addEventListener("DOMContentLoaded", function(event) { 
// this should be made smarter or something
//window.onload = function () {

// There are "scroll" events we need to prevent during a "pause-scroll" session.
var scrollEvents = 'scroll wheel DOMMouseScroll mousewheel MozMousePixelScroll touchmove';

// Cache last scrollTop value. This is used to determine if pauseScroll
// should exit early.
var lastScrollTopKey = "lastScrollTop::" + location.pathname;
var lastScrollTop = +sessionStorage.getItem(lastScrollTopKey);

// Store the last scrollTop value whenever the scroll event is triggered.
window.addEventListener('scroll', _.debounce(function() {
  var scrollTop = Math.max(document.body.scrollTop, document.documentElement.scrollTop);
  sessionStorage.setItem(lastScrollTopKey, scrollTop);
}, 100))

/**
 * Recursively calculate an element's offset height.
 */
function offsetTop(el) {
  var offset = el.offsetTop;
  while ((el = el.offsetParent) != null) {
    offset = offset + el.offsetTop;
  }
  return offset;
}

/**
 * Prevent the browser from scrolling for time `duration` in ms. Additionally,
 * animate scrolling back to position of `el` with an offset calculated based
 * on triggerAfter.
 *
 * @param {element} el Target element.
 * @param {number} duration Time in milliseconds to prevent scrolling.
 * @param {number|string} triggerAfter Percentage of viewport height to offset.
 */
function pauseScroll(el, duration, triggerAfter, curHeight) {
  // only bounce if curHeight > bounceAfter
  var bounceAfter = 0.5 + triggerAfter;
  // Compute scrollTop for tween
  var scrollTop = offsetTop(el) - window.innerHeight * (100 - triggerAfter) / 100;
  // Cache scrollLeft for tween
  var scrollLeft = document.body.scrollLeft;
  /* Al changed duration from 300 to 600 */
  var bounceDuration = 600;

  // exit early if animation is above the viewport
  if (scrollTop < lastScrollTop) return;


disableScroll();
  // Prevent user scrolling
  addEventListeners(window, scrollEvents, preventEvent);


  // Animate scrolling to scrollTop. Kind of like a bounce.
  if (curHeight > bounceAfter) {
	disableScroll();

    d3.select('body')
      .transition().duration(bounceDuration).tween('scroll', scrollTween(scrollLeft, scrollTop + 1));
  }


 disableScroll();

  // Allow user to scroll after `duration` ms have ellapsed
  setTimeout(removeEventListeners.bind(null, window, scrollEvents, preventEvent), duration);
  setTimeout(enableScroll, duration);
}


function scrollTween(scrollLeft, scrollTop) {
  return function() {
    var i = d3.interpolateNumber(window.pageYOffset || document.documentElement.scrollTop, scrollTop);
    return function(t) { scrollTo(scrollLeft, i(t)); };
  };
}

function addEventListeners(el, eventNames, listener) {
  eventNames.trim().split(/\s+/).forEach(function(eventName) {
    el.addEventListener(eventName, listener);
  });
}

function removeEventListeners(el, eventNames, listener) {
  eventNames.trim().split(/\s+/).forEach(function(eventName) {
    el.removeEventListener(eventName, listener);
  });
}

function preventEvent(e) { e.preventDefault(); e.stopPropagation(); }

// note: this will fail if <body> position is set to relative
var elementHeight = function(e) {
    var curOffset = 0;
    var curNode = e;
    while(curNode.offsetParent != null) {
        curOffset += curNode.offsetTop;
        curNode = curNode.offsetParent;
    }
    // http://blogs.telerik.com/jefffritz/posts/14-01-17/chrome-updated-scrolltop
    var scrollAmount = (document.body.scrollTop) ?
            document.body.scrollTop :
            document.documentElement.scrollTop;
    // var scrollAmount = document.documentElement.scrollTop + document.body.scrollTop;
    return (100 * (window.innerHeight - (curOffset - scrollAmount)) / window.innerHeight);
}

var debugHeightElement = document.getElementById("debug-height");
if (debugHeightElement != null) {
    window.onscroll = function() {
        var height = elementHeight(debugHeightElement);
        debugHeightElement.innerHTML = "" + height;
    }
}

function loadstring(s) {
    var thearray = [];
    for (var i = 0, strLength=s.length; i < strLength; i++) {
        thearray.push(s[i]);
    }
    return thearray;
}

var vis = d3.selectAll(".rp-wavy")

//TODO: why isn't phase working?
vis.each(function(d,i) {
    var start = Date.now();

    var wavyParams = {
        "animate": "true",
        "phase": "0",
        "amplitude": "6",
        "frequency": "1",
        "wavelength": "1"
    };
    var setAttributes = this.dataset;
    // override with any set attributes
    for (var attrname in setAttributes) { wavyParams[attrname] = setAttributes[attrname]; }
    var selectedParent = d3.select(this);
    var myArray = loadstring(selectedParent.text());
    selectedParent.text("");
    var myLength = myArray.length;
    var offset = 0;
    //console.log(wavyParams.phase);
    var waveFunction = function(d,i) {
            var denom = parseFloat(wavyParams.wavelength) * (myLength - 1.0);
            var frac = (i / denom); // [0..1]
            frac = frac + parseFloat(wavyParams.frequency) * (2*Math.PI*parseFloat(wavyParams.phase) + offset);
            var ypos = Math.floor(parseFloat(wavyParams.amplitude) * Math.sin(frac*2*Math.PI));
            return String(ypos)+"px"
        };

    selectedParent.selectAll("span")
        .data(myArray)
        .enter().append("span")
        .style("position", "relative")
        .style("margin", "0")
        .style("padding", "0.75pt")
        .style("top", waveFunction)
        .text(String);

    if(wavyParams.animate === 'true') {
        d3.timer(function() {
            var elapsed = Date.now() - start;
            offset = elapsed/1000.0;

            selectedParent.selectAll("span")
                .data(myArray)
                .style("top", waveFunction);
        });
    }

})

var lerp = function(t, a, b) {
  return (a + t * (b - a));
}

/* returns an array of elements */
var parseColor = function(color_string) {
    var re = /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/;
    var bits = re.exec(color_string);
    var colorArray = [0,0,0];
    if(bits) {
        var colorArray = [parseInt(bits[1], 10), parseInt(bits[2], 10), parseInt(bits[3], 10)];
    }
    return colorArray;
}

var emitColor = function(s) {
    var entry = [0, 0, 0];
    if(typeof s === typeof [] && s.length >= 2) {
        entry = s;
    }
    return "rgb(" + entry[0] + "," + entry[1] + "," + entry[2] + ")";
}

var interpColor = function(t, a, b) {
    var r =  Math.floor(lerp(t, a[0], b[0]));
    var g =  Math.floor(lerp(t, a[1], b[1]));
    var b =  Math.floor(lerp(t, a[2], b[2]));
    return [r, g, b];
}

var clone = function(obj) {
    if (null == obj || "object" != typeof obj) return obj;
    var copy = obj.constructor();
    for (var attr in obj) {
        if (obj.hasOwnProperty(attr)) copy[attr] = obj[attr];
    }
    return copy;
}

var masterEmptyShadowEntry = {
    'x': 0.0,
    'y': 0.0,
    'blur': 0.0,
    'color': [0, 0, 0]
};

/* returns a special map */
var parseShadow = function(shadow_string) {
    var entryList = [];
    var eachShadow = shadow_string.split("x,");
    _.each(eachShadow, function (shadow_part) {
        var entry = clone(masterEmptyShadowEntry);
        var parenPos = shadow_part.indexOf(")");
        if(parenPos !== -1 && parenPos < (shadow_part.length - 1)) {
            var firstPart = shadow_part.substring(0, parenPos+1).trim();
            var lastPart = shadow_part.substring(parenPos+1).trim();
            entry['color'] = parseColor(firstPart);
            var eachField = lastPart.split(" ");
            if(eachField.length > 0) {
                entry['x'] = parseFloat(eachField[0]);
            }
            if(eachField.length > 1) {
                entry['y'] = parseFloat(eachField[1]);
            }
            if(eachField.length > 2) {
                entry['blur'] = parseFloat(eachField[2]);
            }
        }
        entryList.push(entry);
    });
    return entryList;
}

var ensureShadowCopy = function(val) {
    var entry = clone(masterEmptyShadowEntry);
    if(typeof val === typeof {}) {
        if(typeof val.color == typeof [])
            entry.color = val.color;
        if(typeof val.x !== 'undefined')
            entry.x = val.x;
        if(typeof val.y !== 'undefined')
            entry.y = val.y;
        if(typeof val.blur !== 'undefined')
            entry.blur = val.blur;
    }
    return entry;
}

var emitShadow = function(a) {
    if (typeof a !== typeof [])
        a = [null];

    var finalString = "";
    var len = a.length;
    for(var i=0; i < len; i+=1) {
        var entry = ensureShadowCopy(a[i]);
        if(i > 0) {
            finalString = finalString + ", ";
        }
        finalString = finalString + emitColor(entry.color) + " " +
            entry.x + "px" + " " +
            entry.y + "px" + " " +
            entry.blur + "px";
    }
    return finalString;
}

var interpShadow = function(t, a, b) {
    if (typeof a !== typeof [])
        a = [null];
    if (typeof b !== typeof [])
        b = [null];

    var maxLength = a.length;
    if(b.length > maxLength) {
        maxLength = b.length;
    }

    c = [];
    for(var i=0; i < maxLength; i+=1) {
        var aa = ensureShadowCopy(a[i]);
        var bb = ensureShadowCopy(b[i]);
        var entry = {};
        entry.color = interpColor(t, aa.color, bb.color);
        entry.x = lerp(t, aa.x, bb.x);
        entry.y = lerp(t, aa.y, bb.y);
        entry.blur = lerp(t, aa.blur, bb.blur);
        c.push(entry);
    }
    return c;
}

var vfr = d3.selectAll(".rp-frame,.rp-trigger")

vfr.each(function(d,i) {
    var start = Date.now();
    var selectedParent = d3.select(this);
    var defaultSwitchTarget = "";
    if(selectedParent.classed('rp-trigger')) {
        defaultSwitchTarget = "self";
        console.log("switchtarget=self")
    }

/* user should be able to define line-heights -->
/* trigger line-height */
    var frameParams = {
        "animate": "true",
        "keys": "letter-spacing,color",
        "duration": "1",
        "loop": "true",
        "delay": "0",
        "triggerAfter": "68",
        "triggerOffset": "0",
        "resetBefore": "65",
        "switchTarget": defaultSwitchTarget,
        "switchClass": "noanim",
        "parentTrigger": ""
    };
    var floatKeys = {
        "letter-spacing": {
            "suffix": "px",
            "zeroword": "normal"
        },
        "font-size": {
            "suffix": "px",
            "zeroword": "0"
        },
        "top": {
            "suffix": "px",
            "zeroword": "auto"
        },
        "right": {
            "suffix": "px",
            "zeroword": "auto"
        },
        "opacity": {
            "suffix": "",
            "zeroword": "0"
        }
    };
    // this.dataset containas all of the "data-" elements
    var setAttributes = this.dataset;
    // override with any set attributes
    for (var attrname in setAttributes) { frameParams[attrname] = setAttributes[attrname]; }
    // console.log(setAttributes);

    var switchTarget = null;
    var parentTrigger = null;
    if(frameParams.switchTarget) {
        if(frameParams.switchTarget == "self") {
            switchTarget = selectedParent;
            console.log(switchTarget);
        }
        else {
            switchTarget = d3.selectAll(frameParams.switchTarget);
        }
        switchTarget.classed(frameParams.switchClass, true);
        // console.log("switchTarget debug:");
        // console.log(switchTarget.length);
        // console.log("end switchTarget debug:");
    }
    if(frameParams.parentTrigger) {
        parentTrigger = d3.select(frameParams.parentTrigger);
        // switchTarget.classed(frameParams.switchClass, true);
    }
    var keyArray = frameParams.keys.split(",");
    var keySet = _.reduce(keyArray, function(memo, str) { memo[str] = true; return memo}, {});
    var framedata = selectedParent[0][0].children;
    var framedataArray = Array.prototype.slice.call( framedata );
    // prepare to save durations
    var totalDuration = 0.0;
    var eachDuration = [];
    var summedDuration = [0];
    var frames = framedataArray.map(function(frame) {
        var curDuration = parseFloat(frameParams.duration);
        if(typeof frame.dataset.duration !== 'undefined') {
            curDuration = parseFloat(frame.dataset.duration);
        }
        totalDuration = totalDuration + curDuration;
        summedDuration.push(totalDuration);
        eachDuration.push(curDuration);
        // console.log(eachDuration, totalDuration, summedDuration);
        var elements = frame.children;
        var elementsArray = Array.prototype.slice.call( elements );
        return elementsArray.map(function(item) {
            var sRow = d3.select(item);
            var map = {};
            _.each(floatKeys, function (params, curKey) {
                //alert(curKey);
                if( curKey in keySet ) {
                    var spacing = sRow.style(curKey)
                    var spacingNum = (spacing === params["zeroword"]) ? "0" : parseFloat(spacing);
                    map[curKey] = spacingNum;
                }
            });
            if( "font-family" in keySet ) {
                map["font-family"] = sRow.style("font-family");
            }
            if( "font-style" in keySet ) {
                map["font-style"] = sRow.style("font-style");
            }
            if( "text-shadow" in keySet ) {
                map["text-shadow"] = parseShadow(sRow.style("text-shadow"));
                //console.log("Shadow: " + sRow.style("text-shadow"), map["text-shadow"], emitShadow(map["text-shadow"]));
            }
            if( "color" in keySet ) {
                map.color = parseColor(sRow.style("color"));
            }
            if( "text" in keySet ) {
                map.text = sRow.text();
            }
            return map;
        });
    });
    //console.log(frames);
    var numFrames = frames.length;
    // remove children (frames) after 0th
    var extras = framedataArray.slice(1);
    extras.forEach(function(child) {
        var sChild = d3.select(child);
        sChild.remove();
    });
    //console.log(framedataArray);

    var offset = 0;
    var animationIsActive = false;
    var animationIsOver = false;
    var initialDelayIsOver = false;
    var hasTriggered = false;
    var isPauseScroll = "pauseScroll" in frameParams;
    // we might eventually have a function here (for non-animating)

    if(frameParams.animate === 'true') {
        // console.log(elementHeight(selectedParent[0][0]));
        // gdebug = selectedParent[0][0];
        d3.timer(function() {
            // first see if we should start or reset
            var curHeight;
            if(parentTrigger) {
                curHeight = elementHeight(parentTrigger[0][0]);
                // commented out by al**** console.log(parentTrigger[0][0]);
            }
            else {
                curHeight = elementHeight(selectedParent[0][0]);
            }
            // gdebug = selectedParent[0][0];
            // console.log(gdebug);

            if(!hasTriggered && curHeight > (+frameParams["triggerAfter"] + +frameParams["triggerOffset"])) {
                console.log("-- triggered at " + curHeight);
                hasTriggered = true;
                start = Date.now();
                if (isPauseScroll) {
                  console.log('-- pausing scroll');
                  delete selectedParent[0][0].dataset.pauseScroll;
                  pauseScroll(parentTrigger ? parentTrigger[0][0] : selectedParent[0][0], +frameParams["pauseScroll"] || 1700, frameParams["triggerAfter"], curHeight);
                  isPauseScroll = false;
                }
            }
            if(!hasTriggered) {
                return;
            }

            var elapsed = Date.now() - start;

            if(!initialDelayIsOver) {
                if(elapsed/1000.0 < frameParams.delay) {
                    // console.log("NO's go!" + elapsed + "," + frameParams.delay);
                    return;
                }
                console.log("Beginning anim: " + elapsed + "ms > " + frameParams.delay);
                initialDelayIsOver = true;
                start = Date.now();
                elapsed = 0.0;
            }

            // console.log("-- cur at " + curHeight);

            //console.log(curHeight);
            var disablingAnimation = false;
            if(!animationIsActive && curHeight > (+frameParams["triggerAfter"] + +frameParams["triggerOffset"])) {
                animationIsActive = true;
                if(switchTarget) {
                    console.log("Resetting switch target ON");
                    switchTarget.classed(frameParams.switchClass, false);
                }
                // initialDelayIsOver = false;
                start = Date.now();
                return;
            }

            if(!animationIsActive) {
                return;
            }

            if(curHeight < frameParams["resetBefore"]) {
                console.log("-- resetting at " + curHeight);
                elapsed = 0.0;
                // doesn't do anything until next go around
                animationIsActive = false;
                animationIsOver = false;
                initialDelayIsOver = false;
                hasTriggered = false;
                if(switchTarget) {
                    console.log("Resetting switch target OFF");
                    switchTarget.classed(frameParams.switchClass, true);
                }
            }

            if(animationIsOver) {
                return;
            }

            offset = (elapsed/1000.0);
            if (offset > totalDuration) {
                if(frameParams.loop === 'true') {
                    offset = offset % totalDuration;
                }
                else {
                    // turn off animation
                    offset = totalDuration - 0.0001;
                    animationIsOver = true;
                }
            }
            var curFrame = -1;
            for(var i=0; i < numFrames && curFrame === -1; i+=1) {
                if(offset < summedDuration[i+1]) {
                    curFrame = i;
                }
            }
            // in case the modulo goes funny
            if(curFrame === -1) {
                offset = 0;
                curFrame = 0;
            }
            // if 0, then just offset
            var numerator = offset - summedDuration[curFrame];
            var denominator = eachDuration[curFrame];
            var remainder = numerator / denominator;
            curFrame = curFrame % numFrames;
            var nextFrame = (curFrame + 1) % numFrames;
            // patch nextFrame to curFrame if not looping and at end
            if(frameParams.loop != 'true' && nextFrame == 0) {
                nextFrame = curFrame;
                animationIsOver = true;
            }

            var child = d3.select(selectedParent[0][0].children[0]);
            var node = child.selectAll("span");
            _.each(floatKeys, function (params, curKey) {
                if( curKey in keySet ) {
                    node.style(curKey, function(d,i) {
                        //console.log(i + ")how about " + remainder + "," + frames[curFrame][i].spacing + "," + frames[nextFrame][i].spacing + ",")
                        var curSpacing = lerp(remainder, frames[curFrame][i][curKey], frames[nextFrame][i][curKey]);
                        return String(curSpacing) + params["suffix"];
                    });
                }
            });
            if( "color" in keySet ) {
                node.style("color", function(d,i) {
                    var c = interpColor(remainder, frames[curFrame][i].color, frames[nextFrame][i].color);
                    return emitColor(c);
                });
            }
            if( "font-family" in keySet ) {
                node.style("font-family", function(d,i) {
                    return frames[curFrame][i]["font-family"];
                });
            }
            if( "font-style" in keySet ) {
                node.style("font-style", function(d,i) {
                    return frames[curFrame][i]["font-style"];
                });
            }
            if( "text-shadow" in keySet ) {
                node.style("text-shadow", function(d,i) {
                    var c = interpShadow(remainder, frames[curFrame][i]['text-shadow'], frames[nextFrame][i]['text-shadow']);
                    return emitShadow(c);
                });
                // console.log("Shadow: " + sRow.style("text-shadow"), map["text-shadow"], emitShadow(map["text-shadow"]));
            }
            if( "text" in keySet ) {
                node.text(function(d,i) {
                    return frames[curFrame][i].text;
                });
            }
        });
    }

})

//}

});


function animateButton2() {
    var knowmoretrigger = document.getElementsByClassName('knowmoretrigger'),
        i = knowmoretrigger.length;

    while(i--) {
        knowmoretrigger[i].style.animationPlayState = "running";
        knowmoretrigger[i].style.mozAnimationPlayState = "running";
        knowmoretrigger[i].style.webkitAnimationPlayState = "running";
        knowmoretrigger[i].style.oAnimationPlayState = "running";
    }
}

(function downLoad(){
    var loader = document.getElementById("page-loader");
    if (loader) loader.parentElement.removeChild(loader);

    document.getElementById("wrapper").style.visibility='visible';
}());

