// this should be made smarter or something
window.onload = function () {

var elementHeight = function(e) {
    var scrollAmount = document.documentElement.scrollTop + document.body.scrollTop;
    return (100 * (window.innerHeight - (e.offsetTop - scrollAmount)) / window.innerHeight);
}

var debugHeightElement = document.getElementById("debug-height");
if (debugHeightElement != null) {
    window.onscroll = function() {
        var height = elementHeight(debugHeightElement);
        debugHeightElement.innerHTML = "" + height;
    }
}

function loadstring(s) {
    var thearray = [];
    for (var i = 0, strLength=s.length; i < strLength; i++) {
        thearray.push(s[i]);
    }
    return thearray;
}

var vis = d3.selectAll(".rp-wavy")

//TODO: why isn't phase working?
vis.each(function(d,i) {
    var start = Date.now();

    var wavyParams = {
        "animate": "true",
        "phase": "0",
        "amplitude": "6",
        "frequency": "1",
        "wavelength": "1"
    };
    var setAttributes = this.dataset;
    // override with any set attributes
    for (var attrname in setAttributes) { wavyParams[attrname] = setAttributes[attrname]; }
    var selectedParent = d3.select(this);
    var myArray = loadstring(selectedParent.text());
    selectedParent.text("");
    var myLength = myArray.length;
    var offset = 0;
    //console.log(wavyParams.phase);
    var waveFunction = function(d,i) {
            var denom = parseFloat(wavyParams.wavelength) * (myLength - 1.0);
            var frac = (i / denom); // [0..1]
            frac = frac + parseFloat(wavyParams.frequency) * (2*Math.PI*parseFloat(wavyParams.phase) + offset);
            var ypos = Math.floor(parseFloat(wavyParams.amplitude) * Math.sin(frac*2*Math.PI));
            return String(ypos)+"px"
        };

    selectedParent.selectAll("span")
        .data(myArray)
        .enter().append("span")
        .style("position", "relative")
        .style("margin", "0")
        .style("padding", "0.75pt")
        .style("top", waveFunction)
        .text(String);

    if(wavyParams.animate === 'true') {
        d3.timer(function() {
            var elapsed = Date.now() - start;
            offset = elapsed/1000.0;

            selectedParent.selectAll("span")
                .data(myArray)
                .style("top", waveFunction);
        });        
    }

})

var lerp = function(t, a, b) {
  return (a + t * (b - a));
}

/* returns an array of elements */
var parseColor = function(color_string) {
    var re = /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/;
    var bits = re.exec(color_string);
    var colorArray = [0,0,0];
    if(bits) {
        var colorArray = [parseInt(bits[1], 10), parseInt(bits[2], 10), parseInt(bits[3], 10)];
    }
    return colorArray;
}

var emitColor = function(s) {
    var entry = [0, 0, 0];
    if(typeof s === typeof [] && s.length >= 2) {
        entry = s;
    }
    return "rgb(" + entry[0] + "," + entry[1] + "," + entry[2] + ")";
}

var interpColor = function(t, a, b) {
    var r =  Math.floor(lerp(t, a[0], b[0]));
    var g =  Math.floor(lerp(t, a[1], b[1]));
    var b =  Math.floor(lerp(t, a[2], b[2]));
    return [r, g, b];
}

var clone = function(obj) {
    if (null == obj || "object" != typeof obj) return obj;
    var copy = obj.constructor();
    for (var attr in obj) {
        if (obj.hasOwnProperty(attr)) copy[attr] = obj[attr];
    }
    return copy;
}

var masterEmptyShadowEntry = {
    'x': 0.0,
    'y': 0.0,
    'blur': 0.0,
    'color': [0, 0, 0]
};

/* returns a special map */
var parseShadow = function(shadow_string) {
    var entryList = [];
    var eachShadow = shadow_string.split("x,");
    _.each(eachShadow, function (shadow_part) {
        var entry = clone(masterEmptyShadowEntry);
        var parenPos = shadow_part.indexOf(")");
        if(parenPos !== -1 && parenPos < (shadow_part.length - 1)) {
            var firstPart = shadow_part.substring(0, parenPos+1).trim();
            var lastPart = shadow_part.substring(parenPos+1).trim();
            entry['color'] = parseColor(firstPart);
            var eachField = lastPart.split(" ");
            if(eachField.length > 0) {
                entry['x'] = parseFloat(eachField[0]);
            }
            if(eachField.length > 1) {
                entry['y'] = parseFloat(eachField[1]);
            }
            if(eachField.length > 2) {
                entry['blur'] = parseFloat(eachField[2]);
            }
        }
        entryList.push(entry);
    });
    return entryList;
}

var ensureShadowCopy = function(val) {
    var entry = clone(masterEmptyShadowEntry);
    if(typeof val === typeof {}) {
        if(typeof val.color == typeof [])
            entry.color = val.color;
        if(typeof val.x !== 'undefined')
            entry.x = val.x;
        if(typeof val.y !== 'undefined')
            entry.y = val.y;
        if(typeof val.blur !== 'undefined')
            entry.blur = val.blur;
    }
    return entry;
}

var emitShadow = function(a) {
    if (typeof a !== typeof [])
        a = [null];

    var finalString = "";
    var len = a.length;
    for(var i=0; i<len; i+=1) {
        var entry = ensureShadowCopy(a[i]);
        if(i > 0) {
            finalString = finalString + ", ";
        }
        finalString = finalString + emitColor(entry.color) + " " + 
            entry.x + "px" + " " +
            entry.y + "px" + " " +
            entry.blur + "px";
    }
    return finalString;
}

var interpShadow = function(t, a, b) {
    if (typeof a !== typeof [])
        a = [null];
    if (typeof b !== typeof [])
        b = [null];

    var maxLength = a.length;
    if(b.length > maxLength) {
        maxLength = b.length;
    }

    c = [];
    for(var i=0; i<maxLength; i+=1) {
        var aa = ensureShadowCopy(a[i]);
        var bb = ensureShadowCopy(b[i]);
        var entry = {};
        entry.color = interpColor(t, aa.color, bb.color);
        entry.x = lerp(t, aa.x, bb.x);
        entry.y = lerp(t, aa.y, bb.y);
        entry.blur = lerp(t, aa.blur, bb.blur);
        c.push(entry);
    }
    return c;
}

var vfr = d3.selectAll(".rp-frame")

vfr.each(function(d,i) {
    var start = Date.now();

    var frameParams = {
        "animate": "true",
        "keys": "letter-spacing,color",
        "duration": "1",
        "loop": "true",
        "delay": "0",
        "trigger-after": "20",
        "reset-before": "-10"
    };
    var floatKeys = {
        "letter-spacing": {
            "suffix": "px",
            "zeroword": "normal"
        },
        "font-size": {
            "suffix": "px",
            "zeroword": "0"
        },
        "top": {
            "suffix": "px",
            "zeroword": "auto"
        },
        "right": {
            "suffix": "px",
            "zeroword": "auto"
        },
        "opacity": {
            "suffix": "",
            "zeroword": "0"
        }
    };
    // this.dataset containas all of the "data-" elements
    var setAttributes = this.dataset;
    // override with any set attributes
    for (var attrname in setAttributes) { frameParams[attrname] = setAttributes[attrname]; }
    var keyArray = frameParams.keys.split(",");
    var keySet = _.reduce(keyArray, function(memo, str) { memo[str] = true; return memo}, {});
    var selectedParent = d3.select(this);
    var framedata = selectedParent[0][0].children;
    var framedataArray = Array.prototype.slice.call( framedata );
    // prepare to save durations
    var totalDuration = 0.0;
    var eachDuration = [];
    var summedDuration = [0];
    var frames = framedataArray.map(function(frame) {
        var curDuration = parseFloat(frameParams.duration);
        if(typeof frame.dataset.duration !== 'undefined') {
            curDuration = parseFloat(frame.dataset.duration);
        }
        totalDuration = totalDuration + curDuration;
        summedDuration.push(totalDuration);
        eachDuration.push(curDuration);
        console.log(eachDuration, totalDuration, summedDuration);
        var elements = frame.children;
        var elementsArray = Array.prototype.slice.call( elements );
        return elementsArray.map(function(item) {
            var sRow = d3.select(item);
            var map = {};
            _.each(floatKeys, function (params, curKey) {
                //alert(curKey);
                if( curKey in keySet ) {
                    var spacing = sRow.style(curKey)
                    var spacingNum = (spacing === params["zeroword"]) ? "0" : parseFloat(spacing);
                    map[curKey] = spacingNum;
                }
            });
            if( "font-family" in keySet ) {
                map["font-family"] = sRow.style("font-family");
            }
            if( "font-style" in keySet ) {
                map["font-style"] = sRow.style("font-style");
            }
            if( "text-shadow" in keySet ) {
                map["text-shadow"] = parseShadow(sRow.style("text-shadow"));
                //console.log("Shadow: " + sRow.style("text-shadow"), map["text-shadow"], emitShadow(map["text-shadow"]));
            }
            if( "color" in keySet ) {
                map.color = parseColor(sRow.style("color"));
            }
            if( "text" in keySet ) {
                map.text = sRow.text();
            }
            return map;
        });
    });
    //console.log(frames);
    var numFrames = frames.length;
    // remove children (frames) after 0th
    var extras = framedataArray.slice(1);
    extras.forEach(function(child) {
        var sChild = d3.select(child);
        sChild.remove();
    });
    //console.log(framedataArray);

    var offset = 0;
    var animationIsActive = false;
    var animationIsOver = false;
    var initialDelayIsOver = false;
    // we might eventually have a function here (for non-animating)

    if(frameParams.animate === 'true') {
        d3.timer(function() {
            var elapsed = Date.now() - start;

            if(!initialDelayIsOver) {
                if(elapsed/1000.0 < frameParams.delay) {
//                    console.log("NO's go!" + elapsed + "," + frameParams.delay);
                    return;
                }
                console.log("Let's go!" + elapsed + "," + frameParams.delay);
                initialDelayIsOver = true;                
                start = Date.now();
                elapsed = 0.0;
            }

            // first see if we should start or reset
            var curHeight = elementHeight(selectedParent[0][0]);
            //console.log(curHeight);
            var disablingAnimation = false;
            if(!animationIsActive && curHeight > frameParams["trigger-after"]) {
                animationIsActive = true;
                start = Date.now();
            }

            if(!animationIsActive || animationIsOver) {
                return;
            }

            if(curHeight < frameParams["reset-before"]) {
                elapsed = 0.0;
                // doesn't do anything until next go around
                animationIsActive = false;
                animationIsOver = false;
                initialDelayIsOver = false;
            }

            offset = (elapsed/1000.0);
            if (offset > totalDuration) {
                if(frameParams.loop === 'true') {
                    offset = offset % totalDuration;
                }
                else {
                    // turn off animation
                    offset = totalDuration - 0.0001;
                    animationIsOver = true;
                }
            }
            var curFrame = -1;
            for(var i=0; i<numFrames && curFrame === -1; i+=1) {
                if(offset < summedDuration[i+1]) {
                    curFrame = i;
                }
            }
            // in case the modulo goes funny
            if(curFrame === -1) {
                offset = 0;
                curFrame = 0;
            }
            // if 0, then just offset
            var numerator = offset - summedDuration[curFrame];
            var denominator = eachDuration[curFrame];
            var remainder = numerator / denominator;
            curFrame = curFrame % numFrames;
            var nextFrame = (curFrame + 1) % numFrames;

            var child = d3.select(selectedParent[0][0].children[0]);
            var node = child.selectAll("span");
            _.each(floatKeys, function (params, curKey) {
                if( curKey in keySet ) {
                    node.style(curKey, function(d,i) {
                        //console.log(i + ")how about " + remainder + "," + frames[curFrame][i].spacing + "," + frames[nextFrame][i].spacing + ",")
                        var curSpacing = lerp(remainder, frames[curFrame][i][curKey], frames[nextFrame][i][curKey]);
                        return String(curSpacing) + params["suffix"];
                    });
                }
            });
            if( "color" in keySet ) {
                node.style("color", function(d,i) {
                    var c = interpColor(remainder, frames[curFrame][i].color, frames[nextFrame][i].color);
                    return emitColor(c);
                });
            }
            if( "font-family" in keySet ) {
                node.style("font-family", function(d,i) {
                    return frames[curFrame][i]["font-family"];
                });
            }
            if( "font-style" in keySet ) {
                node.style("font-style", function(d,i) {
                    return frames[curFrame][i]["font-style"];
                });
            }
            if( "text-shadow" in keySet ) {
                node.style("text-shadow", function(d,i) {
                    var c = interpShadow(remainder, frames[curFrame][i]['text-shadow'], frames[nextFrame][i]['text-shadow']);
                    return emitShadow(c);
                });
                // console.log("Shadow: " + sRow.style("text-shadow"), map["text-shadow"], emitShadow(map["text-shadow"]));
            }
            if( "text" in keySet ) {
                node.text(function(d,i) {
                    return frames[curFrame][i].text;
                });
            }
        });
    }

})

}
